<?php

namespace Modules\Kitchen\Livewire;

use App\Models\KotPlace;
use App\Models\MenuItem;
use Livewire\Component;
use Modules\Kitchen\Entities\Kitchen;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\WithPagination;

class AllKitchens extends Component
{
    use LivewireAlert, WithPagination;
    public $search = '';
    public $name;
    public $showEditKitchenModal = false;
    public $selectedKitchen;
    public $confirmDeleteKitchenPlacesModal = false;
    public $deleteKitchenPlaces;
    public $deleteExpense;
    public $showAddItemModal = false;
    public $selectedKitchenId;
    public $showKitchenStatusModal = false;
    public $selectedItems = [];

    public function mount($search = '')
    {
        $this->search = $search;
    }

    public function showEditKitchen($kitchenId)
    {
        $this->selectedKitchen = KotPlace::find($kitchenId);
        $this->showEditKitchenModal = true;
    }

    #[On('hideEditKitchen')]
    public function hideEditKitchen()
    {
        $this->showEditKitchenModal = false;
    }

    public function confirmDeleteKitchenPlaces($id)
    {
        $this->deleteKitchenPlaces = $id;
        $this->confirmDeleteKitchenPlacesModal = true;
    }

    public function deleteKitchenPlace()
    {
        $kitchen = KotPlace::find($this->deleteKitchenPlaces);

        if ($kitchen && $kitchen->is_default) {
            $this->alert('error', __('kitchen::messages.cannotDeleteDefaultKitchen'), [
                'toast' => true,
                'position' => 'top-end',
                'showCancelButton' => false,
                'cancelButtonText' => __('app.close')
            ]);
        } else {
            $kitchen?->delete();

            $this->alert('success', __('kitchen::messages.KitchenPlacesDeleted'), [
                'toast' => true,
                'position' => 'top-end',
                'showCancelButton' => false,
                'cancelButtonText' => __('app.close')
            ]);
        }

        $this->confirmDeleteKitchenPlacesModal = false;
        $this->deleteKitchenPlaces = null;
    }

    public function showKitchenStatusPopup($kitchenId)
    {
        $this->selectedKitchenId = $kitchenId;
        $this->showKitchenStatusModal = true;
    }

    #[On('hideKitchenStatusPopup')]
    public function hideshowKitchenStatusPopup()
    {
        $this->showKitchenStatusModal = false;
    }

    public function toggleKitchenStatus()
    {
        $kitchen = KotPlace::with('menuItems')->find($this->selectedKitchenId);

        if ($kitchen->is_default) {
            $this->alert('error', __('kitchen::messages.cannotInactiveDefaultKitchen'), [
                'toast' => true,
                'position' => 'top-end',
                'showCancelButton' => false,
                'cancelButtonText' => __('app.close')
            ]);
            $this->dispatch('hideKitchenStatusPopup');
            return;
        }

        if ($kitchen->is_active == true) {
            $defaultKitchen = KotPlace::where('is_default', true)->first();

            if ($kitchen && $defaultKitchen && $kitchen->id !== $defaultKitchen->id) {
                $kitchen->menuItems()->update(['kot_place_id' => $defaultKitchen->id]);
            }
        }

        $kitchen->is_active = !$kitchen->is_active;
        $kitchen->save();

        $this->dispatch('hideKitchenStatusPopup');

        $this->alert('success', __('messages.settingsUpdated'), [
            'toast' => true,
            'position' => 'top-end',
            'showCancelButton' => false,
            'cancelButtonText' => __('app.close')
        ]);
    }

    public function addItemToKitchen($kitchenId)
    {
        $this->selectedKitchenId = $kitchenId;
        $this->showAddItemModal = true;
    }

    #[On('hideItemToKitchen')]
    public function hideItemToKitchen()
    {

        $this->showAddItemModal = false;
    }

    public function render()
    {
        $kitchens = KotPlace::with(['printerSetting', 'menuItems'])
            ->when($this->search, function ($query) {
                $query->where('name', 'like', '%' . $this->search . '%');
            })
            ->paginate(10);

        return view('kitchen::livewire.all-kitchens', [
            'kitchens' => $kitchens,
        ]);
    }
}
