<div>
    <div class="overflow-x-auto">
        <div class="inline-block min-w-full align-middle">
            <div class="overflow-hidden shadow">
                <table class="min-w-full divide-y divide-gray-200 table-fixed dark:divide-gray-600">
                    <thead class="bg-gray-100 dark:bg-gray-700">
                        <tr>
                            <th class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                {{ __('kitchen::modules.menu.kitchenName') }}
                            </th>
                            <th class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                {{ __('kitchen::modules.menu.description') }}
                            </th>
                                <th class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                    {{ __('kitchen::modules.menu.printerName') }}
                                </th>
                            <th class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                {{ __('kitchen::modules.menu.numberOfItems') }}
                            </th>
                            <th class="py-2.5 px-4 text-xs font-medium text-left text-gray-500 uppercase dark:text-gray-400">
                                {{ __('kitchen::modules.menu.isActive') }}
                            </th>
                            <th class="py-2.5 px-4 text-xs font-medium ltr:text-end rtl:text-start text-gray-500 uppercase dark:text-gray-400">
                                {{ __('kitchen::modules.menu.action') }}
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200 dark:bg-gray-800 dark:divide-gray-700">
                        @foreach ($kitchens as $kitchen)
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700">
                                <td class="py-2.5 px-4 text-left text-gray-900 dark:text-white">
                                    {{ $kitchen->name }}
                                </td>
                                <td class="py-2.5 px-4 text-left text-gray-900 dark:text-white">
                                    {{ Str::title($kitchen->type) }}
                                </td>
                                <td class="py-2.5 px-4 text-left text-gray-900 dark:text-white text-sm">
                                    {{ Str::title($kitchen->printerSetting?->name ?? '--') }} {{ $kitchen->printerSetting?->type == 'windows' ? '('.$kitchen->printerSetting?->share_name.')' : '' }}
                                </td>
                                <td class="py-2.5 px-4 text-left text-gray-900 dark:text-white">
                                    {{ $kitchen->menuitems->count() }}
                                </td>
                                <td class="py-3 px-4 text-left text-gray-900 dark:text-white">
                                    <div class="flex items-center">
                                        <input type="checkbox" id="isActive-{{ $kitchen->id }}"
                                            wire:click="showKitchenStatusPopup({{ $kitchen->id }})"
                                            @if ($kitchen->is_active) checked @endif
                                            class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500">
                                        <label for="isActive-{{ $kitchen->id }}"
                                            class="ml-2 text-sm text-gray-600 dark:text-gray-400">
                                            @lang('app.active')
                                        </label>
                                    </div>
                                </td>
                                <td class="py-2.5 px-4 ltr:text-end rtl:text-start space-x-2">
                                    {{-- Add, Edit, Delete buttons --}}
                                    <x-secondary-button-table wire:click="addItemToKitchen({{ $kitchen->id }})">
                                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd"
                                            d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                            clip-rule="evenodd" />
                                    </svg>
                                        {{ __('kitchen::modules.menu.addItem') }}
                                    </x-secondary-button-table>

                                    <x-secondary-button-table wire:click="showEditKitchen({{ $kitchen->id }})">
                                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M17.414 2.586a2 2 0 00-2.828 0L7 10.172V13h2.828l7.586-7.586a2 2 0 000-2.828z">
                                            </path>
                                            <path fill-rule="evenodd"
                                                d="M2 6a2 2 0 012-2h4a1 1 0 010 2H4v10h10v-4a1 1 0 112 0v4a2 2 0 01-2 2H4a2 2 0 01-2-2V6z"
                                                clip-rule="evenodd"></path>
                                        </svg>
                                        {{ __('kitchen::modules.menu.edit') }}
                                    </x-secondary-button-table>

                                    <x-danger-button-table wire:click="confirmDeleteKitchenPlaces({{ $kitchen->id }})">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd"
                                                d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </x-danger-button-table>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
        </div>
    </div>

    <x-right-modal wire:model="showEditKitchenModal">
        <x-slot name="title">
            {{ __('kitchen::modules.menu.editKitchenPlaces') }}
        </x-slot>

        <x-slot name="content">
            @if ($selectedKitchen)
                @livewire('edit-kitchen', ['kitchen' => $selectedKitchen], key(str()->random(50)))
            @endif
        </x-slot>

        <x-slot name="footer">

        </x-slot>
    </x-right-modal>

     <x-dialog-modal wire:model="showAddItemModal">
        <x-slot name="title">
            {{ __('kitchen::modules.menu.manageItems') }}
        </x-slot>

        <x-slot name="content">
            @if ($selectedKitchenId)
                @livewire('add-item-to-kitchen', ['kitchenId' => $selectedKitchenId], key(str()->random(50)))
            @endif
        </x-slot>

        <x-slot name="footer">

        </x-slot>

     </x-dialog-modal>

    <x-confirmation-modal wire:model="confirmDeleteKitchenPlacesModal">
        <x-slot name="title">
            @lang('kitchen::modules.menu.deleteKitchen')?
        </x-slot>

        <x-slot name="content">
            @lang('kitchen::modules.menu.deleteKitchenPlacesMessage')
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('confirmDeleteKitchenPlacesModal')" wire:loading.attr="disabled">
                {{ __('kitchen::modules.menu.cancel') }}
            </x-secondary-button>

            @if ($deleteKitchenPlaces)
                <x-danger-button class="ml-3" wire:click='deleteKitchenPlace' wire:loading.attr="disabled">
                    {{ __('kitchen::modules.menu.delete') }}
                </x-danger-button>
            @endif

        </x-slot>
    </x-confirmation-modal>

    <x-confirmation-modal wire:model="showKitchenStatusModal">
        <x-slot name="title">
            @lang('kitchen::modules.menu.changeStatus')?
        </x-slot>

        <x-slot name="content">
            @lang('kitchen::messages.statusChangeMessage')
        </x-slot>

        <x-slot name="footer">
            <x-secondary-button wire:click="$toggle('showKitchenStatusModal')" wire:loading.attr="disabled">
                {{ __('kitchen::modules.menu.cancel') }}
            </x-secondary-button>

            @if ($selectedKitchenId)
                <x-danger-button class="ml-3" wire:click='toggleKitchenStatus' wire:loading.attr="disabled">
                    {{ __('kitchen::modules.menu.changeStatus') }}
                </x-danger-button>
            @endif

        </x-slot>
    </x-confirmation-modal>



</div>
