# Profit and Loss Report

## Overview

The Profit and Loss Report provides a comprehensive analysis of restaurant profitability by comparing sales revenue with ingredient costs for each menu item. This report helps restaurant owners and managers understand which menu items are most profitable and identify opportunities for cost optimization.

## Features

### 1. Sales Revenue Calculation
- **Source**: Order items from completed orders (excluding canceled orders)
- **Data Points**: 
  - Total quantity sold per menu item
  - Average unit price
  - Total sales amount
  - Date range filtering

### 2. Ingredient Cost Calculation
- **Source**: Recipe system linking menu items to inventory items
- **Calculation**: 
  - For each menu item, get all ingredients from recipes
  - Calculate cost per ingredient: `quantity × unit_purchase_price`
  - Total ingredient cost = sum of all ingredient costs × quantity sold

### 3. Profit Analysis
- **Profit**: `Total Sales - Ingredient Cost`
- **Profit Margin**: `(Profit / Total Sales) × 100`
- **Sorting**: Items sorted by profit (highest to lowest)

## Report Structure

### Summary Cards
- **Total Sales**: Overall revenue from all menu items
- **Total Cost**: Total ingredient costs for all sold items
- **Total Profit**: Net profit (sales - costs)

### Detailed Table
Each row shows:
- Menu item name
- Category
- Quantity sold
- Average unit price
- Total sales amount
- Ingredient cost
- Profit
- Profit margin percentage

## Filters

### Date Range
- Start date and end date selection
- Default: Current month
- Format: Date and time picker

### Category Filter
- Filter by menu item category
- Option to view all categories
- Helps focus on specific menu sections

## Usage

### Accessing the Report
1. Navigate to Inventory → Reports
2. Click on "Profit & Loss" tab
3. Set your desired date range and category filters
4. Click "Generate Report"

### Interpreting Results
- **Green values**: Positive profit/margin
- **Red values**: Negative profit/margin
- **High profit margin items**: Consider increasing prices or promoting
- **Low profit margin items**: Review ingredient costs or pricing strategy

## Technical Implementation

### Database Tables Used
- `orders`: Order information and status
- `order_items`: Individual items in orders with prices
- `menu_items`: Menu item details and categories
- `recipes`: Links menu items to inventory items
- `inventory_items`: Ingredient details and purchase prices

### Key Calculations
```php
// Sales Revenue
$totalSales = SUM(order_items.amount)

// Ingredient Cost
$ingredientCost = SUM(recipe.quantity × inventory_item.unit_purchase_price) × quantity_sold

// Profit
$profit = $totalSales - $ingredientCost

// Profit Margin
$profitMargin = ($profit / $totalSales) × 100
```

## Benefits

1. **Profitability Analysis**: Identify most and least profitable menu items
2. **Cost Control**: Monitor ingredient costs and their impact on profitability
3. **Menu Optimization**: Make data-driven decisions about menu pricing and composition
4. **Inventory Management**: Understand which ingredients contribute most to costs
5. **Business Intelligence**: Track profitability trends over time

## Limitations

- Only considers ingredient costs (excludes labor, overhead, etc.)
- Requires accurate recipe setup for meaningful results
- Depends on proper inventory item pricing
- Historical data only (real-time updates not available)

## Future Enhancements

- Export functionality (Excel/PDF)
- Labor cost inclusion
- Overhead allocation
- Trend analysis over time
- Comparative period analysis
- Cost variance reporting 